#ifndef DDEBUG_H
    #define DDEBUG_H

    #include "DPlataforma.h"
//    #include "assert.h"

    #ifdef _DEBUG
        #define DWL_IMPRIMIR_DEBUG(...)         DDebug::ImprimirDebug(__VA_ARGS__);
        #define DWL_MOSTRAR_ULTIMO_ERROR(...)   DDebug::MostrarUltimoError(__VA_ARGS__);
    #else
        #define DWL_IMPRIMIR_DEBUG(...)
        #define DWL_MOSTRAR_ULTIMO_ERROR(...)   
    #endif

    namespace DWL {
        class DDebug {
          public:
                            DDebug(void) { };

		                    //! Funcin que imprime texto por la pantallita de debug
                            /*! Funcin que imprime texto por la pantallita de debug, al estilo del printf
		                            \fn			static void	ImprimirDebug(const TCHAR *Txt, ...);
								    \param[in]	Txt		: Puntero a una cadena de texto
								    \param[in]	...		: Parametros opcionales
                                    \return     No devuelve nada
                            */
            static void     ImprimirDebug(const TCHAR *nTxt, ...);

		                    //! Funcin que muestra un MessageBox con el ultimo error del sistema.
                            /*! Funcin que muestra un MessageBox con el ultimo error del sistema. Ademas puedes aadir texto delante del mensaje del sistema. 
		                            \fn			static void	MostrarUltimoError(const TCHAR *Mensaje = NULL);
								    \param[in]	Mensaje	: Puntero a una cadena de texto del estilo printf la cual puede ser NULL o puede contener datos extras del error
								    \param[in]	...		: Parametros opcionales para aadir al estilo printf
                                    \return     No devuelve nada
                            */
            static void	    MostrarUltimoError(const TCHAR *Mensaje = NULL, ...);
        };
    };

#endif